# BrokersDB Position Sizer v1.00 - Complete User Guide

## 1. Overview
The **BrokersDB Position Sizer** is a premium, high-contrast, free position sizing tool and trading panel for MetaTrader 5. Built to replace manual lot size calculations, the EA empowers traders to execute trades instantly while maintaining strict risk management rules. It features dynamic lines on the chart for visual risk adjustment, ATR-based automated stop loss/take profit calculations, split take-profit features, and a sleek user interface inspired by modern platforms like Binance and TradingView.

## 2. Installation and First Steps
1. Place the `BrokersDB_PositionSizer` folder inside your MetaTrader 5 data folder: `MQL5/Experts/Advisors/`.
2. Refresh the MetaTrader 5 Navigator panel, then drag and drop the EA onto any chart.
3. In the EA configuration window, check the **"Allow Algo Trading"** option. Without this, the EA can calculate sizes but will not be able to execute trades.
4. **Terms and Conditions**: When successfully attached to the chart, a disclaimer dialog will appear. Click "Yes" to agree that you are using this tool at your own risk.

## 3. The 5-Tab Interface

### 3.1. Main Tab (Position Sizer)
The Main tab is the core of the tool. 
- **Type**: Choose between Instant Execution, Pending Orders (Limit/Stop), or Stop Limit (MT5 specific).
- **Direction**: Choose Long (Buy) or Short (Sell). By clicking the directional triangle button next to the EA name when the panel is minimized, you can instantly swap directions.
- **Entry, Stop-Loss, Take-Profit**: Set manually by typing, or simply drag the colored lines on the chart.
- **Risk % / Risk $**: Define your risk either in percentage of your Account/Equity/Balance or in fixed currency.
- **Reward**: Displays your real-time R:R ratio and expected monetary reward.
- **Position Size**: Automatically calculated based on your Risk and Stop Loss distance. You can manually tweak this, but the panel will recalculate risk data.

### 3.2. Risk Tab
This tab calculates your overall Portfolio Risk. 
- **Filters**: Choose to filter existing tracked positions by Symbols (Current vs All), Directions (Buy vs Sell), or Order Types (Open vs Pending).
- **Current vs Potential**: Compare what you currently risk/have floating vs. what the risk will be *if* you execute the trade currently calculated in the Main Tab.
- **Metrics shown**: Risk amount, risk percentage, reward, R:R, and exposed volume.

### 3.3. Margin Tab
Displays metrics related to margin consumption for the upcoming trade.
- **Custom Leverage**: Input a custom leverage to simulate how margin requirements would look under different conditions.
- **Max PS (Margin)**: The maximum volume (lot size) the broker allows you to open with your remaining margin.

### 3.4. Swaps Tab
Presents critical overnight rollover costs (swap values) for the current symbol as determined by your broker.
- **Long/Short Swaps**: Check point values, percentage, or currency charges.
- **3-Days Swap**: Shows which day the broker charges triple swap (usually Wednesday).

### 3.5. Trading Tab
This tab manages trade executions and advanced conditions.
- **TRADE button**: Finalizes and executes your calculated trade. An alert will ask for confirmation (if `g_askConfirmation` is enabled).
- **Trailing / BE**: Define points to automatically trail your stop loss or bring it to Break Even once in profit.
- **Checkboxes**:
  - `No SL` / `No TP`: Execute position without them.
  - `Subtract OPV/POV`: Advanced logic to subtract currently open/pending volumes dynamically.
  - `Disable if hidden`: Trading is disabled if the user has intentionally hidden the chart lines (using the `Hide Lines` button on the main tab).
- **Multi-TP Setup**: Set multiple partial Take Profit levels. Use the `Share%` fields to define how much volume fires off at each TP level. Use `Fill In`/`Fill Out` to auto spread the levels based on linear progressions.

## 4. Chart Visualization (The Drag-and-Drop Lines)
Once loaded, three primary lines will appear:
- **Green line**: Entry (if pending/stop limit)
- **Red line**: Stop Loss
- **Blue line**: Take Profit

By dragging these lines anywhere on the chart, the panel instantly recalculates the risk, the R:R ratios, and the lot size needed. This provides a "what-you-see-is-what-you-get" experience.

## 5. Input Settings & Customization
Press F7 to access the expert properties window. The Inputs tab is highly categorized:

- **UI & Colors**: Select Dark Mode or Light mode manually, or use "Auto Detect from Chart background". Customize panel positions and dimensions.
- **Hotkeys**: Assign keyboard shortcuts for nearly all major panel functions (e.g., executing a trade, hiding lines).
- **ATR Features**: Configure ATR Timeframes and Multipliers to have the Stop Loss auto-adjust to current market volatility.
- **Broker Constraints**: Add "Fuses" such as Max Slippage, Max Spread limits, and Volumetric restraints completely preventing trades if conditions are unfavorable.

## 6. Disclaimer and Risk Disclosure
**Notice:** Trading Forex, CFDs, and other financial instruments is highly speculative and carries a high level of risk. The BrokersDB Position Sizer is a mathematical tool designed to assist in position calculating and fast execution. BrokersDB and its developers hold no responsibility for broker requotes, execution failures, bugs, slippages, financial losses, or inaccurate calculations. ALWAYS test new Expert Advisors on a demo account before risking real money.

*Version 1.00 - Designed by BrokersDB.com*
