//+------------------------------------------------------------------+
//|                                                      Defines.mqh |
//|                        Copyright 2025-2026, BrokersDB.com        |
//|                                     https://www.brokersdb.com    |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025-2026, BrokersDB.com"
#property link      "https://www.brokersdb.com"
#property strict

#ifndef DEFINES_MQH
#define DEFINES_MQH

//--- Object name prefix to avoid conflicts with other EAs/indicators
#define BDB_PREFIX          "BDB_"
#define BDB_SETTINGS_DIR    "BrokersDB_PositionSizer"
#define BDB_SETTINGS_FILE   "BrokersDB_PS_Settings"

//--- Panel dimensions — premium spacious layout
#define PANEL_WIDTH         350
#define PANEL_HEADER_H      32
#define PANEL_TAB_H         28
#define PANEL_ROW_H         24
#define PANEL_SPACING       5
#define PANEL_MARGIN        12
#define PANEL_LABEL_W       110
#define PANEL_EDIT_W        120
#define PANEL_BTN_W         70
#define PANEL_BTN_SM_W      36
#define PANEL_FONT_SIZE     9
#define PANEL_FONT_NAME     "Segoe UI"
#define PANEL_TITLE_FONT    "Segoe UI Semibold"
#define PANEL_FOOTER_H      22

//--- Panel tab identifiers
enum ENUM_PANEL_TAB
{
   TAB_MAIN    = 0,  // Main
   TAB_RISK    = 1,  // Risk
   TAB_MARGIN  = 2,  // Margin
   TAB_SWAPS   = 3,  // Swaps
   TAB_TRADING = 4   // Trading
};

//--- Order mode (Instant, Pending, Stop Limit)
enum ENUM_ORDER_MODE
{
   ORDER_MODE_INSTANT    = 0,  // Instant
   ORDER_MODE_PENDING    = 1,  // Pending
   ORDER_MODE_STOP_LIMIT = 2   // Stop Limit
};

//--- Trade direction
enum ENUM_TRADE_DIR
{
   TRADE_DIR_LONG  = 0,  // Long
   TRADE_DIR_SHORT = 1   // Short
};

//--- Account size base
enum ENUM_ACCOUNT_BUTTON
{
   ACCT_BALANCE          = 0,  // Balance
   ACCT_EQUITY           = 1,  // Equity
   ACCT_BALANCE_MINUS_CPR= 2   // Balance - CPR
};

//--- Commission type
enum ENUM_COMMISSION_TYPE
{
   COMMISSION_CURRENCY = 0,  // Currency units
   COMMISSION_PERCENT  = 1   // Percentage
};

//--- Spread display mode
enum ENUM_SPREAD_DISPLAY
{
   SPREAD_HIDE       = 0,  // No
   SPREAD_POINTS     = 1,  // Points
   SPREAD_PERCENT_SL = 2   // % of SL
};

//--- Include orders filter (Risk tab)
enum ENUM_INCLUDE_ORDERS
{
   INCLUDE_ORDERS_ALL     = 0,  // All
   INCLUDE_ORDERS_OPEN    = 1,  // Open
   INCLUDE_ORDERS_PENDING = 2   // Pending
};

//--- Include symbols filter (Risk tab)
enum ENUM_INCLUDE_SYMBOLS
{
   INCLUDE_SYMBOLS_ALL     = 0,  // All
   INCLUDE_SYMBOLS_CURRENT = 1,  // Current
   INCLUDE_SYMBOLS_OTHER   = 2   // Other
};

//--- Include directions filter (Risk tab)
enum ENUM_INCLUDE_DIRECTIONS
{
   INCLUDE_DIRECTIONS_ALL  = 0,  // All
   INCLUDE_DIRECTIONS_BUY  = 1,  // Buy
   INCLUDE_DIRECTIONS_SELL = 2   // Sell
};

//--- Symbol change behavior
enum ENUM_SYMBOL_CHANGE
{
   SYMBOL_CHANGE_EACH_OWN  = 0,  // Each Own Settings
   SYMBOL_CHANGE_HARD_RESET= 1,  // Hard Reset
   SYMBOL_CHANGE_KEEP      = 2   // Keep Panel
};

//--- Additional trade button placement
enum ENUM_TRADE_BUTTON_POS
{
   TRADE_BTN_NONE  = 0,  // None
   TRADE_BTN_ENTRY = 1,  // Above Entry line
   TRADE_BTN_MAIN  = 2,  // Main tab
   TRADE_BTN_BOTH  = 3   // Both
};

//--- ATR candle selection
enum ENUM_ATR_CANDLE
{
   ATR_CANDLE_CURRENT  = 0,  // Current candle
   ATR_CANDLE_PREVIOUS = 1   // Previous candle
};

//--- TP share distribution mode
enum ENUM_SHARE_MODE
{
   SHARE_EQUAL      = 0,  // Equal
   SHARE_DESCENDING = 1,  // Descending
   SHARE_ASCENDING  = 2   // Ascending
};

//--- Color scheme structure — extended with accent/footer colors
struct SColorScheme
{
   color    clrBackground;
   color    clrBorder;
   color    clrHeaderBg;
   color    clrHeaderText;
   color    clrTabActive;
   color    clrTabInactive;
   color    clrTabText;
   color    clrTabAccent;       // Active tab underline/accent
   color    clrLabelText;
   color    clrEditBg;
   color    clrEditText;
   color    clrEditBorder;
   color    clrButtonBg;
   color    clrButtonText;
   color    clrBtnLong;
   color    clrBtnShort;
   color    clrBtnTrade;
   color    clrResultText;
   color    clrWarning;
   color    clrPositive;
   color    clrNegative;
   color    clrSeparator;
   color    clrFooterBg;
   color    clrFooterText;
};

//--- Panel state structure
struct SPanelState
{
   int               posX;
   int               posY;
   bool              isMinimized;
   bool              isVisible;
   ENUM_PANEL_TAB    activeTab;
   bool              linesVisible;
};

//--- Calculation results structure
struct SCalcResult
{
   double   lotSize;             // Calculated position size
   double   lotSizeAdjusted;     // Adjusted for broker limits
   double   riskMoney;           // Risk in account currency (input)
   double   riskMoneyResult;     // Risk in account currency (result, adjusted)
   double   riskPercent;         // Risk as % of account
   double   riskPercentResult;   // Risk as % (result, adjusted)
   double   rewardMoney;         // Potential reward (input)
   double   rewardMoneyResult;   // Potential reward (result, adjusted)
   double   rewardRiskRatio;     // R:R ratio (input)
   double   rewardRiskResult;    // R:R ratio (result, adjusted)
   double   pointValue;          // Value per point for position
   double   positionMargin;      // Required margin for position
   double   futureUsedMargin;    // Used margin after opening
   double   futureFreeMargin;    // Free margin after opening
   double   maxLotsByMargin;     // Max position by margin
   int      slDistancePoints;    // SL distance in points
   int      tpDistancePoints;    // TP distance in points
};

//--- Portfolio risk structure
struct SPortfolioRisk
{
   double   currentRiskMoney;
   double   currentRiskPercent;
   double   potentialRiskMoney;
   double   potentialRiskPercent;
   double   currentRewardMoney;
   double   currentRewardPercent;
   double   potentialRewardMoney;
   double   potentialRewardPercent;
   double   currentLots;
   double   potentialLots;
   double   currentRRRatio;
   double   potentialRRRatio;
};

//--- Multi-TP level structure
struct STPLevel
{
   double   price;      // TP price level
   double   sharePct;   // Share percentage (0-100)
   double   lots;       // Calculated lots for this level
};

//+-----------------------------------------------------------------+
//| Light color scheme — Clean Professional (TradingView-inspired)   |
//+-----------------------------------------------------------------+
SColorScheme GetLightScheme()
{
   SColorScheme s;
   s.clrBackground   = C'252,253,255';     // Near-white with blue tint
   s.clrBorder        = C'205,210,220';     // Soft border
   s.clrHeaderBg      = C'25,33,52';        // Deep navy header
   s.clrHeaderText    = C'255,255,255';
   s.clrTabActive     = C'252,253,255';     // Match background
   s.clrTabInactive   = C'235,238,245';     // Subtle grey
   s.clrTabText       = C'90,100,118';      // Muted tab text
   s.clrTabAccent     = C'56,116,255';      // Blue accent underline
   s.clrLabelText     = C'50,55,70';        // Dark readable text
   s.clrEditBg        = C'255,255,255';     // Pure white inputs
   s.clrEditText      = C'20,24,32';        // Near-black text
   s.clrEditBorder    = C'205,210,220';     // Matching border
   s.clrButtonBg      = C'240,243,250';     // Very light button bg
   s.clrButtonText    = C'35,42,58';        // Dark button text
   s.clrBtnLong       = C'38,166,154';      // TradingView teal-green
   s.clrBtnShort      = C'239,83,80';       // TradingView coral-red
   s.clrBtnTrade      = C'56,116,255';      // Professional blue
   s.clrResultText    = C'56,116,255';      // Blue results
   s.clrWarning       = C'255,160,30';      // Warm orange
   s.clrPositive      = C'38,166,154';      // Green
   s.clrNegative      = C'239,83,80';       // Red
   s.clrSeparator     = C'225,228,235';     // Subtle separator
   s.clrFooterBg      = C'240,243,250';     // Light footer
   s.clrFooterText    = C'140,148,165';     // Muted footer text
   return s;
}

//+-----------------------------------------------------------------+
//| Dark color scheme — Binance/DarkPool-inspired premium dark       |
//+-----------------------------------------------------------------+
SColorScheme GetDarkScheme()
{
   SColorScheme s;
   s.clrBackground   = C'22,24,30';        // Deep dark background
   s.clrBorder        = C'40,46,56';        // Subtle border
   s.clrHeaderBg      = C'14,16,22';        // Nearly black header
   s.clrHeaderText    = C'240,242,246';
   s.clrTabActive     = C'22,24,30';        // Match background
   s.clrTabInactive   = C'28,32,40';        // Slightly lighter
   s.clrTabText       = C'120,130,148';     // Muted tab text
   s.clrTabAccent     = C'240,185,11';      // Binance gold accent
   s.clrLabelText     = C'148,158,175';     // Readable grey text
   s.clrEditBg        = C'38,42,52';        // Dark input background
   s.clrEditText      = C'235,238,244';     // Light input text
   s.clrEditBorder    = C'46,52,64';        // Subtle input border
   s.clrButtonBg      = C'38,42,52';        // Dark button bg
   s.clrButtonText    = C'220,224,232';     // Light button text
   s.clrBtnLong       = C'2,192,118';       // Bright crypto green
   s.clrBtnShort      = C'248,73,96';       // Bright crypto red
   s.clrBtnTrade      = C'240,185,11';      // Gold trade button
   s.clrResultText    = C'240,242,246';     // White results
   s.clrWarning       = C'240,185,11';      // Binance gold
   s.clrPositive      = C'2,192,118';       // Crypto green
   s.clrNegative      = C'248,73,96';       // Crypto red
   s.clrSeparator     = C'40,46,56';        // Subtle separator
   s.clrFooterBg      = C'18,20,26';        // Darker footer
   s.clrFooterText    = C'90,98,115';       // Dim footer text
   return s;
}

#endif // DEFINES_MQH
