//+------------------------------------------------------------------+
//|                                                      Globals.mqh |
//|                        Copyright 2025-2026, BrokersDB.com        |
//|                                     https://www.brokersdb.com    |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025-2026, BrokersDB.com"
#property link      "https://www.brokersdb.com"
#property strict

#ifndef GLOBALS_MQH
#define GLOBALS_MQH

#include "Defines.mqh"
#include "InputParams.mqh"

//+------------------------------------------------------------------+
//| Global runtime state variables                                    |
//+------------------------------------------------------------------+

//--- Panel state
SPanelState    g_panelState;
SColorScheme   g_colors;
bool           g_darkMode         = false;
bool           g_panelDragging    = false;
int            g_dragOffsetX      = 0;
int            g_dragOffsetY      = 0;

//--- Active tab
ENUM_PANEL_TAB g_activeTab        = TAB_MAIN;

//--- Trade parameters (live, modifiable via panel)
ENUM_TRADE_DIR g_tradeDir         = TRADE_DIR_LONG;
ENUM_ORDER_MODE g_orderMode       = ORDER_MODE_INSTANT;
double         g_entryPrice       = 0;
double         g_stopLossPrice    = 0;
double         g_takeProfitPrice  = 0;
double         g_stopPrice        = 0;  // For stop limit orders
bool           g_slInPoints       = false;
bool           g_tpInPoints       = false;
int            g_slPointsValue    = 0;
int            g_tpPointsValue    = 0;

//--- ATR state
int            g_atrPeriod        = 14;
double         g_atrMultiplierSL  = 0;
double         g_atrMultiplierTP  = 0;
ENUM_TIMEFRAMES g_atrTimeframe    = PERIOD_CURRENT;
bool           g_spreadAdjSL      = false;
bool           g_spreadAdjTP      = false;
double         g_atrValue         = 0;
int            g_atrHandle        = INVALID_HANDLE;

//--- Risk parameters
ENUM_ACCOUNT_BUTTON g_accountBase = ACCT_BALANCE;
double         g_accountSize      = 0;
double         g_riskPercent      = 1.0;
double         g_riskMoney        = 0;
double         g_commission       = 0;
ENUM_COMMISSION_TYPE g_commType   = COMMISSION_CURRENCY;

//--- Calculation results
SCalcResult    g_calcResult;
SPortfolioRisk g_portfolioRisk;

//--- Multi-TP state
int            g_tpCount          = 1;
STPLevel       g_tpLevels[];      // Dynamic array of TP levels
bool           g_tpLockedOnSL     = false;
double         g_tpMultiplier     = 1.0;

//--- Lines visibility
bool           g_linesVisible     = true;

//--- Trading parameters
long           g_magicNumber      = 2026022100;
string         g_commentary       = "";
bool           g_autoSuffix       = false;
int            g_trailingStop     = 0;
int            g_breakEven        = 0;
int            g_maxSlippage      = 0;
int            g_maxSpread        = 0;
int            g_maxEntrySLDist   = 0;
int            g_minEntrySLDist   = 0;
double         g_maxRiskPct       = 0;
int            g_maxTradesTotal   = 0;
int            g_maxTradesSymbol  = 0;
double         g_maxVolTotal      = 0;
double         g_maxVolSymbol     = 0;
double         g_maxTotalRisk     = 0;
double         g_maxTotalRiskSym  = 0;
bool           g_subtractOPV      = false;
bool           g_subtractPOV      = false;
bool           g_noStopLoss       = false;
bool           g_noTakeProfit     = false;
bool           g_disableTradingHidden = false;
bool           g_askConfirmation  = true;
int            g_expiryMinutes    = 0;

//--- Risk tab filters
ENUM_INCLUDE_ORDERS     g_includeOrders    = INCLUDE_ORDERS_ALL;
ENUM_INCLUDE_SYMBOLS    g_includeSymbols   = INCLUDE_SYMBOLS_ALL;
ENUM_INCLUDE_DIRECTIONS g_includeDirections= INCLUDE_DIRECTIONS_ALL;
bool           g_ignoreNoSL       = false;
bool           g_ignoreNoTP       = false;

//--- Margin tab
double         g_customLeverage   = 0;

//--- Previous symbol (for symbol change detection)
string         g_prevSymbol       = "";

//--- Object prefix (runtime copy)
string         g_prefix           = "BDB_";

//--- Trade symbol
string         g_tradeSymbol      = "";

//--- Suffix counter for auto-suffix
int            g_suffixCounter    = 0;

//+------------------------------------------------------------------+
//| InitializeGlobals — Set globals from input parameters             |
//+------------------------------------------------------------------+
void InitializeGlobals()
{
   //--- Color scheme
   g_darkMode = InpDarkMode;
   if(InpAutoDetectDark)
   {
      color chartBg = (color)ChartGetInteger(0, CHART_COLOR_BACKGROUND);
      // If chart background is dark (low sum of RGB), use dark mode
      int r = (int)((chartBg & 0xFF));
      int g = (int)((chartBg >> 8) & 0xFF);
      int b = (int)((chartBg >> 16) & 0xFF);
      if(r + g + b < 382) // Midpoint threshold
         g_darkMode = true;
      else
         g_darkMode = false;
   }
   g_colors = g_darkMode ? GetDarkScheme() : GetLightScheme();

   //--- Panel state
   g_panelState.posX = InpPanelX;
   g_panelState.posY = InpPanelY;
   g_panelState.isMinimized = InpStartMinimized;
   g_panelState.isVisible = true;
   g_panelState.activeTab = TAB_MAIN;
   g_panelState.linesVisible = InpShowLines;
   g_activeTab = TAB_MAIN;

   //--- Trade parameters
   g_tradeDir       = InpTradeDirection;
   g_orderMode      = InpEntryType;
   g_slInPoints     = InpSLDistInPoints;
   g_tpInPoints     = InpTPDistInPoints;
   g_linesVisible   = InpShowLines;
   g_tpLockedOnSL   = InpTPLocked;
   g_tpMultiplier   = InpTPMultiplier;

   //--- ATR
   g_atrPeriod      = InpATRPeriod;
   g_atrMultiplierSL= InpATRMultiplierSL;
   g_atrMultiplierTP= InpATRMultiplierTP;
   g_atrTimeframe   = InpATRTimeframe;
   g_spreadAdjSL    = InpSpreadAdjSL;
   g_spreadAdjTP    = InpSpreadAdjTP;

   //--- Risk
   g_accountBase    = InpAccountButton;
   g_riskPercent    = InpRisk;
   g_riskMoney      = InpMoneyRisk;
   g_commission     = InpCommission;
   g_commType       = InpCommissionType;

   //--- Multi-TP
   g_tpCount = InpTakeProfitsNumber;
   if(g_tpCount < 1) g_tpCount = 1;
   ArrayResize(g_tpLevels, g_tpCount);
   for(int i = 0; i < g_tpCount; i++)
   {
      g_tpLevels[i].price    = 0;
      g_tpLevels[i].sharePct = (i == 0) ? 100.0 : 0;
      g_tpLevels[i].lots     = 0;
   }

   //--- Trading params
   g_magicNumber    = InpMagicNumber;
   g_commentary     = InpCommentary;
   g_autoSuffix     = InpAutoSuffix;
   g_trailingStop   = InpTrailingStop;
   g_breakEven      = InpBreakEven;
   g_maxSlippage    = InpMaxSlippage;
   g_maxSpread      = InpMaxSpread;
   g_maxEntrySLDist = InpMaxEntrySLDist;
   g_minEntrySLDist = InpMinEntrySLDist;
   g_maxRiskPct     = InpMaxRiskPercent;
   g_maxTradesTotal = InpMaxTradesTotal;
   g_maxTradesSymbol= InpMaxTradesSymbol;
   g_maxVolTotal    = InpMaxPosSizeTotal;
   g_maxVolSymbol   = InpMaxPosSizeSymbol;
   g_maxTotalRisk   = InpMaxTotalRisk;
   g_maxTotalRiskSym= InpMaxTotalRiskSymbol;
   g_subtractOPV    = InpSubtractOPV;
   g_subtractPOV    = InpSubtractPOV;
   g_noStopLoss     = InpNoStopLoss;
   g_noTakeProfit   = InpNoTakeProfit;
   g_disableTradingHidden = InpDisableTradingHidden;
   g_askConfirmation= InpAskConfirmation;
   g_expiryMinutes  = InpExpiryMinutes;

   //--- Risk tab filters
   g_includeOrders    = InpIncludeOrders;
   g_includeSymbols   = InpIncludeSymbols;
   g_includeDirections= InpIncludeDirections;
   g_ignoreNoSL       = InpIgnoreNoSL;
   g_ignoreNoTP       = InpIgnoreNoTP;

   //--- Margin
   g_customLeverage   = InpCustomLeverage;

   //--- Object prefix
   g_prefix = InpObjectPrefix;
   if(g_prefix == "") g_prefix = "BDB_";

   //--- Trade symbol
   g_tradeSymbol = InpTradeSymbol;
   if(g_tradeSymbol == "") g_tradeSymbol = _Symbol;

   //--- Previous symbol init
   g_prevSymbol = _Symbol;

   //--- Suffix counter
   g_suffixCounter = 0;
}

#endif // GLOBALS_MQH
