//+------------------------------------------------------------------+
//|                                                  InputParams.mqh |
//|                        Copyright 2025-2026, BrokersDB.com        |
//|                                     https://www.brokersdb.com    |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025-2026, BrokersDB.com"
#property link      "https://www.brokersdb.com"
#property strict

#ifndef INPUT_PARAMS_MQH
#define INPUT_PARAMS_MQH

#include "Defines.mqh"

//+------------------------------------------------------------------+
//| Group: Compactness — Panel display options                        |
//+------------------------------------------------------------------+
input group "=== Display Options ==="
input bool     InpShowLineLabels        = true;           // Show SL/TP distance labels on lines
input bool     InpShowSLInfoLabel       = false;          // Show risk info above SL line
input bool     InpShowTPInfoLabel       = false;          // Show reward info above TP line
input bool     InpShowEntryLabel        = false;          // Show position size above Entry line
input bool     InpDrawLabelsAsBackground= false;          // Draw line labels as background
input bool     InpHideAccountSize       = false;          // Hide account size display
input bool     InpShowPointValue        = false;          // Show point value on Main tab
input bool     InpShowMaxPSButton       = false;          // Show Max Position Size button
input bool     InpStartMinimized        = false;          // Start panel minimized
input bool     InpShowATROptions        = false;          // Show ATR-based SL/TP options
input bool     InpShowMaxParams         = true;           // Show max parameters on Trading tab
input bool     InpShowFuses             = true;           // Show trade fuses on Trading tab
input bool     InpShowCheckboxes        = true;           // Show checkboxes on Trading tab
input bool     InpHideEntryOnInstant    = false;          // Hide Entry line on Instant orders
input ENUM_TRADE_BUTTON_POS InpTradeButtons = TRADE_BTN_NONE; // Additional Trade buttons

//+------------------------------------------------------------------+
//| Group: Fonts — Font settings for line labels                      |
//+------------------------------------------------------------------+
input group "=== Line Label Fonts ==="
input color    InpSLLabelColor          = clrGreen;       // SL Label Font Color
input color    InpTPLabelColor          = clrGoldenrod;   // TP Label Font Color
input color    InpStopPriceLabelColor   = clrPurple;      // Stop Price Label Font Color
input color    InpEntryLabelColor       = clrBlue;        // Entry Label Font Color
input int      InpLabelFontSize         = 13;             // Labels Font Size
input string   InpLabelFontFace        = "Trebuchet MS";  // Labels Font Face

//+------------------------------------------------------------------+
//| Group: Lines — Chart line appearance                              |
//+------------------------------------------------------------------+
input group "=== Chart Lines ==="
input color    InpEntryLineColor        = clrBlue;        // Entry Line Color
input color    InpSLLineColor           = clrGreen;       // Stop-Loss Line Color
input color    InpTPLineColor           = clrGoldenrod;   // Take-Profit Line Color
input color    InpStopPriceLineColor    = clrPurple;      // Stop Price Line Color
input color    InpBELineColor           = clrNONE;        // Breakeven Line Color
input ENUM_LINE_STYLE InpEntryLineStyle = STYLE_SOLID;    // Entry Line Style
input ENUM_LINE_STYLE InpSLLineStyle    = STYLE_SOLID;    // Stop-Loss Line Style
input ENUM_LINE_STYLE InpTPLineStyle    = STYLE_SOLID;    // Take-Profit Line Style
input ENUM_LINE_STYLE InpStopPriceStyle = STYLE_DOT;      // Stop Price Line Style
input ENUM_LINE_STYLE InpBELineStyle    = STYLE_DOT;      // Breakeven Line Style
input int      InpEntryLineWidth        = 1;              // Entry Line Width
input int      InpSLLineWidth           = 1;              // Stop-Loss Line Width
input int      InpTPLineWidth           = 1;              // Take-Profit Line Width
input int      InpStopPriceLineWidth    = 1;              // Stop Price Line Width
input int      InpBELineWidth           = 1;              // Breakeven Line Width

//+------------------------------------------------------------------+
//| Group: Defaults — Default values for panel controls               |
//+------------------------------------------------------------------+
input group "=== Default Values ==="
input ENUM_TRADE_DIR       InpTradeDirection    = TRADE_DIR_LONG;        // Default Trade Direction
input int                  InpDefaultSL         = 0;                     // Default SL (points, 0=disabled)
input int                  InpDefaultTP         = 0;                     // Default TP (points, 0=disabled)
input int                  InpTakeProfitsNumber = 1;                     // Number of Take-Profit levels
input ENUM_ORDER_MODE      InpEntryType         = ORDER_MODE_INSTANT;    // Default Order Type
input bool                 InpShowLines         = true;                  // Show Lines by default
input bool                 InpLinesSelected     = true;                  // Lines Selected for moving
input int                  InpATRPeriod         = 14;                    // ATR Period
input double               InpATRMultiplierSL   = 0;                    // ATR Multiplier for SL
input double               InpATRMultiplierTP   = 0;                    // ATR Multiplier for TP
input ENUM_TIMEFRAMES      InpATRTimeframe      = PERIOD_CURRENT;       // ATR Timeframe
input bool                 InpSpreadAdjSL       = false;                // Spread Adjustment for SL
input bool                 InpSpreadAdjTP       = false;                // Spread Adjustment for TP
input double               InpCommission        = 0;                    // Default Commission (one-way)
input ENUM_COMMISSION_TYPE InpCommissionType    = COMMISSION_CURRENCY;   // Commission Type
input ENUM_ACCOUNT_BUTTON  InpAccountButton     = ACCT_BALANCE;         // Account Size Base
input double               InpRisk              = 1.0;                  // Default Risk (%)
input double               InpMoneyRisk         = 0;                    // Default Money Risk (0=use %)
input ENUM_INCLUDE_ORDERS  InpIncludeOrders     = INCLUDE_ORDERS_ALL;   // Include Orders (Risk tab)
input bool                 InpIgnoreNoSL        = false;                // Ignore orders without SL
input bool                 InpIgnoreNoTP        = false;                // Ignore orders without TP
input ENUM_INCLUDE_SYMBOLS InpIncludeSymbols    = INCLUDE_SYMBOLS_ALL;  // Include Symbols (Risk tab)
input ENUM_INCLUDE_DIRECTIONS InpIncludeDirections = INCLUDE_DIRECTIONS_ALL; // Include Directions
input double               InpCustomLeverage    = 0;                    // Custom Leverage (0=default)
input long                 InpMagicNumber       = 2026022100;           // Magic Number
input string               InpCommentary        = "";                   // Order Commentary
input bool                 InpAutoSuffix        = false;                // Auto-suffix commentary
input bool                 InpDisableTradingHidden = false;             // Disable trading when hidden
input int                  InpMaxSlippage       = 0;                    // Max Slippage (points)
input int                  InpMaxSpread         = 0;                    // Max Spread (points)
input int                  InpMaxEntrySLDist    = 0;                    // Max Entry/SL Distance
input int                  InpMinEntrySLDist    = 0;                    // Min Entry/SL Distance
input double               InpMaxRiskPercent    = 0;                    // Max Risk % per trade
input double               InpMaxPosSizeTotal   = 0;                    // Max Position Size Total
input double               InpMaxPosSizeSymbol  = 0;                    // Max Position Size per Symbol
input bool                 InpSubtractOPV       = false;                // Subtract Open Positions Volume
input bool                 InpSubtractPOV       = false;                // Subtract Pending Orders Volume
input bool                 InpNoStopLoss        = false;                // Do Not Apply Stop-Loss
input bool                 InpNoTakeProfit      = false;                // Do Not Apply Take-Profit
input bool                 InpAskConfirmation   = true;                 // Ask for Confirmation
input int                  InpPanelX            = 0;                    // Panel Position X
input int                  InpPanelY            = 15;                   // Panel Position Y
input ENUM_BASE_CORNER     InpPanelCorner       = CORNER_LEFT_UPPER;    // Panel Position Corner
input bool                 InpTPLocked          = false;                // TP Locked on SL
input int                  InpTrailingStop      = 0;                    // Trailing Stop (points)
input int                  InpBreakEven         = 0;                    // Breakeven (points)
input int                  InpExpiryMinutes     = 0;                    // Pending Order Expiry (min)
input int                  InpMaxTradesTotal    = 0;                    // Max # Trades Total
input int                  InpMaxTradesSymbol   = 0;                    // Max # Trades per Symbol
input double               InpMaxTotalRisk      = 0;                    // Max Total Risk (%)
input double               InpMaxTotalRiskSymbol= 0;                   // Max Risk per Symbol (%)
input bool                 InpSLDistInPoints    = false;                // SL Distance in Points mode
input bool                 InpTPDistInPoints    = false;                // TP Distance in Points mode

//+------------------------------------------------------------------+
//| Group: Keyboard Shortcuts                                         |
//+------------------------------------------------------------------+
input group "=== Keyboard Shortcuts ==="
input string   InpHKTrade          = "Shift+T";    // Trade Hotkey
input string   InpHKOrderType      = "O";          // Switch Order Type Hotkey
input string   InpHKDirection      = "TAB";        // Switch Direction Hotkey
input string   InpHKHideLines      = "H";          // Hide/Show Lines Hotkey
input string   InpHKSetSL          = "S";          // Set SL at cursor Hotkey
input string   InpHKSetTP          = "P";          // Set TP at cursor Hotkey
input string   InpHKSetEntry       = "E";          // Set Entry at cursor Hotkey
input string   InpHKMinimize       = "`";          // Minimize/Maximize Hotkey
input string   InpHKSLMode         = "Shift+S";    // SL Points/Level switch Hotkey
input string   InpHKTPMode         = "Shift+P";    // TP Points/Level switch Hotkey

//+------------------------------------------------------------------+
//| Group: Miscellaneous                                              |
//+------------------------------------------------------------------+
input group "=== Miscellaneous ==="
input double   InpTPMultiplier       = 1.0;                           // TP Multiplier (for quick TP button)
input bool     InpCommissionInTP     = false;                         // Use Commission to set TP distance
input ENUM_SPREAD_DISPLAY InpShowSpread = SPREAD_HIDE;                // Show Spread
input double   InpAdditionalFunds    = 0;                             // Additional Funds
input double   InpCustomBalance      = 0;                             // Custom Balance (0=actual)
input ENUM_ATR_CANDLE InpATRCandle   = ATR_CANDLE_CURRENT;            // ATR Candle
input bool     InpUnadjustedPS       = false;                         // Calculate unadjusted position size
input bool     InpSurpassMaxPS       = false;                         // Surpass broker max position size
input bool     InpRoundDown          = true;                          // Round Down position size
input double   InpQuickRisk1         = 0;                             // Quick Risk Button 1 (%)
input double   InpQuickRisk2         = 0;                             // Quick Risk Button 2 (%)
input string   InpObjectPrefix       = "BDB_";                        // Object Name Prefix
input ENUM_SYMBOL_CHANGE InpSymbolChange = SYMBOL_CHANGE_EACH_OWN;    // On Symbol Change
input bool     InpDisableStopLimit   = false;                         // Disable Stop Limit order type
input string   InpTradeSymbol        = "";                            // Trade Symbol (empty=chart)
input bool     InpDisableTradeSounds = false;                         // Disable Trading Sounds
input bool     InpIgnoreMarketExec   = true;                          // Ignore Market Execution Mode
input bool     InpMarketModeSLTPAfter= false;                         // SL/TP after all trades (Market mode)
input bool     InpDarkMode           = false;                         // Dark Mode
input bool     InpAutoDetectDark     = false;                         // Auto-Detect Dark Mode
input string   InpSettingsFile       = "";                            // Settings File
input bool     InpPrefillTPs         = true;                          // Prefill additional TPs from main
input bool     InpAskBeforeClose     = false;                         // Ask before closing panel
input bool     InpCapPSByMargin      = false;                         // Cap position size by margin
input bool     InpLessRestrictive    = false;                         // Less restrictive max limits
input color    InpLongButtonColor    = C'38,166,154';                 // Long Button Color
input color    InpShortButtonColor   = C'239,83,80';                  // Short Button Color
input color    InpTradeButtonColor   = C'41,98,255';                  // Trade Button Color
input bool     InpKeepLinesOnRemove  = false;                         // Keep lines when EA removed

#endif // INPUT_PARAMS_MQH
