//+------------------------------------------------------------------+
//|                                                  PanelMargin.mqh |
//|                        Copyright 2025-2026, BrokersDB.com        |
//|                                     https://www.brokersdb.com    |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025-2026, BrokersDB.com"
#property link      "https://www.brokersdb.com"
#property strict

#ifndef PANEL_MARGIN_MQH
#define PANEL_MARGIN_MQH

#include "Defines.mqh"
#include "Globals.mqh"
#include "Utilities.mqh"
#include "Calculator.mqh"

#define MG_EDT_LEVERAGE  "EdtLeverage"

int g_marginTabHeight = 0;

//+------------------------------------------------------------------+
void CreateMarginTab()
{
   int x = g_panelState.posX + PANEL_MARGIN;
   int y = g_panelState.posY + PANEL_HEADER_H + PANEL_TAB_H + PANEL_SPACING + 2;
   int w = PANEL_WIDTH - 2 * PANEL_MARGIN;
   int h = PANEL_ROW_H;
   int row = 0;

   //--- Position Margin
   CreateLabel(0, ObjName("LblPosMargin"), x, y+row*(h+PANEL_SPACING)+3, "Position Margin:", g_colors.clrLabelText);
   CreateLabel(0, ObjName("ValPosMargin"), x+140, y+row*(h+PANEL_SPACING)+3,
      FormatMoneyShort(g_calcResult.positionMargin), g_colors.clrResultText);
   row++;

   //--- Future Used Margin
   CreateLabel(0, ObjName("LblFutUsed"), x, y+row*(h+PANEL_SPACING)+3, "Future Used Mar.:", g_colors.clrLabelText);
   CreateLabel(0, ObjName("ValFutUsed"), x+140, y+row*(h+PANEL_SPACING)+3,
      FormatMoneyShort(g_calcResult.futureUsedMargin), g_colors.clrResultText);
   row++;

   //--- Future Free Margin
   CreateLabel(0, ObjName("LblFutFree"), x, y+row*(h+PANEL_SPACING)+3, "Future Free Mar.:", g_colors.clrLabelText);
   color freeColor = (g_calcResult.futureFreeMargin >= 0) ? g_colors.clrPositive : g_colors.clrNegative;
   CreateLabel(0, ObjName("ValFutFree"), x+140, y+row*(h+PANEL_SPACING)+3,
      FormatMoneyShort(g_calcResult.futureFreeMargin), freeColor);
   row++;

   //--- Separator
   CreateRectLabel(0, ObjName("SepMarg1"), x, y+row*(h+PANEL_SPACING), w, 1, g_colors.clrSeparator, g_colors.clrSeparator);
   row++;

   //--- Custom Leverage
   CreateLabel(0, ObjName("LblCustLev"), x, y+row*(h+PANEL_SPACING)+3, "Custom Leverage:", g_colors.clrLabelText);
   string levText = (g_customLeverage > 0) ? FormatDouble(g_customLeverage, 0) : "0 (default)";
   CreateEdit(0, ObjName(MG_EDT_LEVERAGE), x+140, y+row*(h+PANEL_SPACING), w-140, h,
      levText, g_colors.clrEditText, g_colors.clrEditBg, g_colors.clrEditBorder);
   row++;

   //--- Default Leverage
   long defaultLev = AccountInfoInteger(ACCOUNT_LEVERAGE);
   CreateLabel(0, ObjName("LblDefLev"), x, y+row*(h+PANEL_SPACING)+3, "Default Leverage:", g_colors.clrLabelText);
   CreateLabel(0, ObjName("ValDefLev"), x+140, y+row*(h+PANEL_SPACING)+3,
      "1:" + IntegerToString(defaultLev), g_colors.clrResultText);
   row++;

   //--- Symbol Leverage (estimated)
   string sym = GetTradeSymbol();
   double marginPerLot = 0;
   ENUM_ORDER_TYPE ot = ORDER_TYPE_BUY;
   double price = GetAsk(sym);
   if(price > 0)
   {
      if(!OrderCalcMargin(ot, sym, 1.0, price, marginPerLot))
         marginPerLot = 0;
   }
   double contractSize = SymbolInfoDouble(sym, SYMBOL_TRADE_CONTRACT_SIZE);
   double symLev = 0;
   if(marginPerLot > 0) symLev = (contractSize * price) / marginPerLot;
   CreateLabel(0, ObjName("LblSymLev"), x, y+row*(h+PANEL_SPACING)+3, "Symbol Leverage:", g_colors.clrLabelText);
   CreateLabel(0, ObjName("ValSymLev"), x+140, y+row*(h+PANEL_SPACING)+3,
      "~1:" + FormatDouble(symLev, 0), g_colors.clrResultText);
   row++;

   //--- Separator
   CreateRectLabel(0, ObjName("SepMarg2"), x, y+row*(h+PANEL_SPACING), w, 1, g_colors.clrSeparator, g_colors.clrSeparator);
   row++;

   //--- Max position size by margin
   CalcMaxLotsByMargin();
   CreateLabel(0, ObjName("LblMaxMarg"), x, y+row*(h+PANEL_SPACING)+3, "Max PS (margin):", g_colors.clrLabelText);
   CreateLabel(0, ObjName("ValMaxMarg"), x+140, y+row*(h+PANEL_SPACING)+3,
      FormatDouble(g_calcResult.maxLotsByMargin, 2) + " lots", g_colors.clrResultText);
   row++;

   g_marginTabHeight = row * (h + PANEL_SPACING) + PANEL_SPACING;
}

//+------------------------------------------------------------------+
bool HandleMarginTabEdit(string editObj)
{
   if(IsObjectClicked(editObj, MG_EDT_LEVERAGE))
   {
      g_customLeverage = StringToDouble(ObjectGetString(0, ObjName(MG_EDT_LEVERAGE), OBJPROP_TEXT));
      return true;
   }
   return false;
}

#endif // PANEL_MARGIN_MQH
