//+------------------------------------------------------------------+
//|                                                    PanelRisk.mqh |
//|                        Copyright 2025-2026, BrokersDB.com        |
//|                                     https://www.brokersdb.com    |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025-2026, BrokersDB.com"
#property link      "https://www.brokersdb.com"
#property strict

#ifndef PANEL_RISK_MQH
#define PANEL_RISK_MQH

#include "Defines.mqh"
#include "Globals.mqh"
#include "Utilities.mqh"

//--- Risk tab object names
#define RT_BTN_ORD_ALL  "BtnOrdAll"
#define RT_BTN_ORD_OPN  "BtnOrdOpn"
#define RT_BTN_ORD_PND  "BtnOrdPnd"
#define RT_BTN_SYM_ALL  "BtnSymAll"
#define RT_BTN_SYM_CUR  "BtnSymCur"
#define RT_BTN_SYM_OTH  "BtnSymOth"
#define RT_BTN_DIR_ALL  "BtnDirAll"
#define RT_BTN_DIR_BUY  "BtnDirBuy"
#define RT_BTN_DIR_SEL  "BtnDirSel"
#define RT_CHK_NO_SL    "ChkNoSL"
#define RT_CHK_NO_TP    "ChkNoTP"

int g_riskTabHeight = 0;

//+------------------------------------------------------------------+
void CreateRiskTab()
{
   int x = g_panelState.posX + PANEL_MARGIN;
   int y = g_panelState.posY + PANEL_HEADER_H + PANEL_TAB_H + PANEL_SPACING + 2;
   int w = PANEL_WIDTH - 2 * PANEL_MARGIN;
   int h = PANEL_ROW_H;
   int row = 0;
   // btnW calculates the available width for 3 buttons, subtracting the offset (55) and spaces (2*2)
   int btnW = (w - 55 - 2*PANEL_SPACING) / 3;
   color actBg = g_colors.clrTabActive;
   color inBg = g_colors.clrTabInactive;

   //--- Include Orders
   CreateLabel(0, ObjName("LblIncOrd"), x, y + row*(h+PANEL_SPACING)+3, "Orders:", g_colors.clrLabelText);
   CreateButton(0, ObjName(RT_BTN_ORD_ALL), x+55, y+row*(h+PANEL_SPACING), btnW, h, "All", g_colors.clrTabText, g_includeOrders==INCLUDE_ORDERS_ALL?actBg:inBg);
   CreateButton(0, ObjName(RT_BTN_ORD_OPN), x+55+btnW+2, y+row*(h+PANEL_SPACING), btnW, h, "Open", g_colors.clrTabText, g_includeOrders==INCLUDE_ORDERS_OPEN?actBg:inBg);
   CreateButton(0, ObjName(RT_BTN_ORD_PND), x+55+2*(btnW+2), y+row*(h+PANEL_SPACING), btnW, h, "Pending", g_colors.clrTabText, g_includeOrders==INCLUDE_ORDERS_PENDING?actBg:inBg);
   row++;

   //--- Include Symbols
   CreateLabel(0, ObjName("LblIncSym"), x, y+row*(h+PANEL_SPACING)+3, "Symbols:", g_colors.clrLabelText);
   CreateButton(0, ObjName(RT_BTN_SYM_ALL), x+55, y+row*(h+PANEL_SPACING), btnW, h, "All", g_colors.clrTabText, g_includeSymbols==INCLUDE_SYMBOLS_ALL?actBg:inBg);
   CreateButton(0, ObjName(RT_BTN_SYM_CUR), x+55+btnW+2, y+row*(h+PANEL_SPACING), btnW, h, "Current", g_colors.clrTabText, g_includeSymbols==INCLUDE_SYMBOLS_CURRENT?actBg:inBg);
   CreateButton(0, ObjName(RT_BTN_SYM_OTH), x+55+2*(btnW+2), y+row*(h+PANEL_SPACING), btnW, h, "Other", g_colors.clrTabText, g_includeSymbols==INCLUDE_SYMBOLS_OTHER?actBg:inBg);
   row++;

   //--- Include Direction
   CreateLabel(0, ObjName("LblIncDir"), x, y+row*(h+PANEL_SPACING)+3, "Direction:", g_colors.clrLabelText);
   CreateButton(0, ObjName(RT_BTN_DIR_ALL), x+55, y+row*(h+PANEL_SPACING), btnW, h, "All", g_colors.clrTabText, g_includeDirections==INCLUDE_DIRECTIONS_ALL?actBg:inBg);
   CreateButton(0, ObjName(RT_BTN_DIR_BUY), x+55+btnW+2, y+row*(h+PANEL_SPACING), btnW, h, "Buy", g_colors.clrTabText, g_includeDirections==INCLUDE_DIRECTIONS_BUY?actBg:inBg);
   CreateButton(0, ObjName(RT_BTN_DIR_SEL), x+55+2*(btnW+2), y+row*(h+PANEL_SPACING), btnW, h, "Sell", g_colors.clrTabText, g_includeDirections==INCLUDE_DIRECTIONS_SELL?actBg:inBg);
   row++;

   //--- Checkboxes
   CreateButton(0, ObjName(RT_CHK_NO_SL), x, y+row*(h+PANEL_SPACING), 18, h, g_ignoreNoSL?"☑":"☐", g_colors.clrLabelText, g_colors.clrBackground);
   CreateLabel(0, ObjName("LblIgnSL"), x+22, y+row*(h+PANEL_SPACING)+3, "Ignore no SL", g_colors.clrLabelText);
   CreateButton(0, ObjName(RT_CHK_NO_TP), x+w/2, y+row*(h+PANEL_SPACING), 18, h, g_ignoreNoTP?"☑":"☐", g_colors.clrLabelText, g_colors.clrBackground);
   CreateLabel(0, ObjName("LblIgnTP"), x+w/2+22, y+row*(h+PANEL_SPACING)+3, "Ignore no TP", g_colors.clrLabelText);
   row++;

   //--- Separator
   CreateRectLabel(0, ObjName("SepRisk"), x, y+row*(h+PANEL_SPACING), w, 1, g_colors.clrSeparator, g_colors.clrSeparator);
   row++;

   //--- Results header
   CreateLabel(0, ObjName("LblRHdr"), x+100, y+row*(h+PANEL_SPACING)+3, "Current", g_colors.clrLabelText);
   CreateLabel(0, ObjName("LblRHdr2"), x+195, y+row*(h+PANEL_SPACING)+3, "Potential", g_colors.clrLabelText);
   row++;

   //--- Risk ($)
   CreateLabel(0, ObjName("LblCRiskM"), x, y+row*(h+PANEL_SPACING)+3, "Risk ($):", g_colors.clrLabelText);
   CreateLabel(0, ObjName("ValCRiskM"), x+100, y+row*(h+PANEL_SPACING)+3, FormatMoneyShort(g_portfolioRisk.currentRiskMoney), g_colors.clrNegative);
   CreateLabel(0, ObjName("ValPRiskM"), x+195, y+row*(h+PANEL_SPACING)+3, FormatMoneyShort(g_portfolioRisk.potentialRiskMoney), g_colors.clrNegative);
   row++;

   //--- Risk (%)
   CreateLabel(0, ObjName("LblCRiskP"), x, y+row*(h+PANEL_SPACING)+3, "Risk (%):", g_colors.clrLabelText);
   CreateLabel(0, ObjName("ValCRiskP"), x+100, y+row*(h+PANEL_SPACING)+3, FormatPercent(g_portfolioRisk.currentRiskPercent), g_colors.clrNegative);
   CreateLabel(0, ObjName("ValPRiskP"), x+195, y+row*(h+PANEL_SPACING)+3, FormatPercent(g_portfolioRisk.potentialRiskPercent), g_colors.clrNegative);
   row++;

   //--- Reward ($)
   CreateLabel(0, ObjName("LblCRewM"), x, y+row*(h+PANEL_SPACING)+3, "Reward ($):", g_colors.clrLabelText);
   CreateLabel(0, ObjName("ValCRewM"), x+100, y+row*(h+PANEL_SPACING)+3, FormatMoneyShort(g_portfolioRisk.currentRewardMoney), g_colors.clrPositive);
   CreateLabel(0, ObjName("ValPRewM"), x+195, y+row*(h+PANEL_SPACING)+3, FormatMoneyShort(g_portfolioRisk.potentialRewardMoney), g_colors.clrPositive);
   row++;

   //--- Reward (%)
   CreateLabel(0, ObjName("LblCRewP"), x, y+row*(h+PANEL_SPACING)+3, "Reward (%):", g_colors.clrLabelText);
   CreateLabel(0, ObjName("ValCRewP"), x+100, y+row*(h+PANEL_SPACING)+3, FormatPercent(g_portfolioRisk.currentRewardPercent), g_colors.clrPositive);
   CreateLabel(0, ObjName("ValPRewP"), x+195, y+row*(h+PANEL_SPACING)+3, FormatPercent(g_portfolioRisk.potentialRewardPercent), g_colors.clrPositive);
   row++;

   //--- Lots
   CreateLabel(0, ObjName("LblCLots"), x, y+row*(h+PANEL_SPACING)+3, "Lots:", g_colors.clrLabelText);
   CreateLabel(0, ObjName("ValCLots"), x+100, y+row*(h+PANEL_SPACING)+3, FormatDouble(g_portfolioRisk.currentLots, 2), g_colors.clrResultText);
   CreateLabel(0, ObjName("ValPLots"), x+195, y+row*(h+PANEL_SPACING)+3, FormatDouble(g_portfolioRisk.potentialLots, 2), g_colors.clrResultText);
   row++;

   //--- R:R
   CreateLabel(0, ObjName("LblCRR"), x, y+row*(h+PANEL_SPACING)+3, "R:R:", g_colors.clrLabelText);
   CreateLabel(0, ObjName("ValCRR"), x+100, y+row*(h+PANEL_SPACING)+3, FormatDouble(g_portfolioRisk.currentRRRatio, 2), g_colors.clrResultText);
   CreateLabel(0, ObjName("ValPRR"), x+195, y+row*(h+PANEL_SPACING)+3, FormatDouble(g_portfolioRisk.potentialRRRatio, 2), g_colors.clrResultText);
   row++;

   g_riskTabHeight = row * (h + PANEL_SPACING) + PANEL_SPACING;
}

//+------------------------------------------------------------------+
bool HandleRiskTabClick(string clickedObj)
{
   if(IsObjectClicked(clickedObj, RT_BTN_ORD_ALL))  { g_includeOrders = INCLUDE_ORDERS_ALL; return true; }
   if(IsObjectClicked(clickedObj, RT_BTN_ORD_OPN))  { g_includeOrders = INCLUDE_ORDERS_OPEN; return true; }
   if(IsObjectClicked(clickedObj, RT_BTN_ORD_PND))  { g_includeOrders = INCLUDE_ORDERS_PENDING; return true; }
   if(IsObjectClicked(clickedObj, RT_BTN_SYM_ALL))  { g_includeSymbols = INCLUDE_SYMBOLS_ALL; return true; }
   if(IsObjectClicked(clickedObj, RT_BTN_SYM_CUR))  { g_includeSymbols = INCLUDE_SYMBOLS_CURRENT; return true; }
   if(IsObjectClicked(clickedObj, RT_BTN_SYM_OTH))  { g_includeSymbols = INCLUDE_SYMBOLS_OTHER; return true; }
   if(IsObjectClicked(clickedObj, RT_BTN_DIR_ALL))  { g_includeDirections = INCLUDE_DIRECTIONS_ALL; return true; }
   if(IsObjectClicked(clickedObj, RT_BTN_DIR_BUY))  { g_includeDirections = INCLUDE_DIRECTIONS_BUY; return true; }
   if(IsObjectClicked(clickedObj, RT_BTN_DIR_SEL))  { g_includeDirections = INCLUDE_DIRECTIONS_SELL; return true; }
   if(IsObjectClicked(clickedObj, RT_CHK_NO_SL))    { g_ignoreNoSL = !g_ignoreNoSL; return true; }
   if(IsObjectClicked(clickedObj, RT_CHK_NO_TP))    { g_ignoreNoTP = !g_ignoreNoTP; return true; }
   return false;
}

#endif // PANEL_RISK_MQH
