//+------------------------------------------------------------------+
//|                                                 PanelTrading.mqh |
//|                        Copyright 2025-2026, BrokersDB.com        |
//|                                     https://www.brokersdb.com    |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025-2026, BrokersDB.com"
#property link      "https://www.brokersdb.com"
#property strict

#ifndef PANEL_TRADING_MQH
#define PANEL_TRADING_MQH

#include "Defines.mqh"
#include "Globals.mqh"
#include "Utilities.mqh"
#include "TradeManager.mqh"

#define TR_BTN_TRADE    "BtnTrade"
#define TR_BTN_FILL_IN  "BtnFillIn"
#define TR_BTN_FILL_OUT "BtnFillOut"
#define TR_BTN_SHARE    "BtnShare"
#define TR_CHK_SUBOPV   "ChkSubOPV"
#define TR_CHK_SUBPOV   "ChkSubPOV"
#define TR_CHK_NOSL     "ChkNoSL"
#define TR_CHK_NOTP     "ChkNoTP"
#define TR_CHK_HIDDEN   "ChkHidden"
#define TR_CHK_CONFIRM  "ChkConfirm"
#define TR_EDT_TRAIL    "EdtTrail"
#define TR_EDT_BE       "EdtBE"
#define TR_EDT_MAGIC    "EdtMagic"
#define TR_EDT_COMMENT  "EdtComment"
#define TR_CHK_SUFFIX   "ChkSuffix"
#define TR_EDT_SLIP     "EdtSlip"
#define TR_EDT_SPREAD   "EdtSpread"
#define TR_EDT_MAXDIST  "EdtMaxDist"
#define TR_EDT_MINDIST  "EdtMinDist"
#define TR_EDT_MAXRISK  "EdtMaxRisk"
#define TR_EDT_MAXTOT   "EdtMaxTot"
#define TR_EDT_MAXSYM   "EdtMaxSym"
#define TR_EDT_MAXVTOT  "EdtMaxVTot"
#define TR_EDT_MAXVSYM  "EdtMaxVSym"
#define TR_EDT_MAXRTOT  "EdtMaxRTot"
#define TR_EDT_MAXRSYM  "EdtMaxRSym"
#define TR_EDT_EXPIRY   "EdtExpiry"

int g_tradingTabHeight = 0;
ENUM_SHARE_MODE g_shareMode = SHARE_EQUAL;

//+------------------------------------------------------------------+
void CreateTradingTab()
{
   int x = g_panelState.posX + PANEL_MARGIN;
   int y = g_panelState.posY + PANEL_HEADER_H + PANEL_TAB_H + PANEL_SPACING + 2;
   int w = PANEL_WIDTH - 2 * PANEL_MARGIN;
   int h = PANEL_ROW_H;
   int row = 0;
   int halfW = (w - PANEL_SPACING) / 2;

   //--- Trade button
   CreateButton(0, ObjName(TR_BTN_TRADE), x, y+row*(h+PANEL_SPACING), w, h+4,
      "TRADE", clrWhite, InpTradeButtonColor, 10, PANEL_TITLE_FONT);
   row++; row++; // Account for larger button height

   //--- Trailing Stop + Breakeven
   CreateLabel(0, ObjName("LblTrail"), x, y+row*(h+PANEL_SPACING)+3, "Trail:", g_colors.clrLabelText);
   CreateEdit(0, ObjName(TR_EDT_TRAIL), x+40, y+row*(h+PANEL_SPACING), 55, h,
      IntegerToString(g_trailingStop), g_colors.clrEditText, g_colors.clrEditBg, g_colors.clrEditBorder);
   CreateLabel(0, ObjName("LblBE"), x+halfW, y+row*(h+PANEL_SPACING)+3, "BE:", g_colors.clrLabelText);
   CreateEdit(0, ObjName(TR_EDT_BE), x+halfW+25, y+row*(h+PANEL_SPACING), 55, h,
      IntegerToString(g_breakEven), g_colors.clrEditText, g_colors.clrEditBg, g_colors.clrEditBorder);
   row++;

   //--- Magic Number
   CreateLabel(0, ObjName("LblMagic"), x, y+row*(h+PANEL_SPACING)+3, "Magic:", g_colors.clrLabelText);
   CreateEdit(0, ObjName(TR_EDT_MAGIC), x+50, y+row*(h+PANEL_SPACING), w-50, h,
      IntegerToString(g_magicNumber), g_colors.clrEditText, g_colors.clrEditBg, g_colors.clrEditBorder);
   row++;

   //--- Commentary
   CreateLabel(0, ObjName("LblComnt"), x, y+row*(h+PANEL_SPACING)+3, "Comment:", g_colors.clrLabelText);
   CreateEdit(0, ObjName(TR_EDT_COMMENT), x+60, y+row*(h+PANEL_SPACING), w-80, h,
      g_commentary, g_colors.clrEditText, g_colors.clrEditBg, g_colors.clrEditBorder, 0, "", CORNER_LEFT_UPPER, ALIGN_LEFT);
   CreateButton(0, ObjName(TR_CHK_SUFFIX), x+w-18, y+row*(h+PANEL_SPACING), 18, h,
      g_autoSuffix?"☑":"☐", g_colors.clrLabelText, g_colors.clrBackground);
   row++;

   //--- Fuses section (if enabled)
   if(InpShowFuses)
   {
      CreateRectLabel(0, ObjName("SepTrd1"), x, y+row*(h+PANEL_SPACING), w, 1, g_colors.clrSeparator, g_colors.clrSeparator);
      row++;

      CreateLabel(0, ObjName("LblSlip"), x, y+row*(h+PANEL_SPACING)+3, "Slippage:", g_colors.clrLabelText);
      CreateEdit(0, ObjName(TR_EDT_SLIP), x+70, y+row*(h+PANEL_SPACING), 50, h,
         IntegerToString(g_maxSlippage), g_colors.clrEditText, g_colors.clrEditBg, g_colors.clrEditBorder);
      CreateLabel(0, ObjName("LblMaxSp"), x+halfW, y+row*(h+PANEL_SPACING)+3, "Spread:", g_colors.clrLabelText);
      CreateEdit(0, ObjName(TR_EDT_SPREAD), x+halfW+55, y+row*(h+PANEL_SPACING), 50, h,
         IntegerToString(g_maxSpread), g_colors.clrEditText, g_colors.clrEditBg, g_colors.clrEditBorder);
      row++;

      CreateLabel(0, ObjName("LblMaxD"), x, y+row*(h+PANEL_SPACING)+3, "MaxDist:", g_colors.clrLabelText);
      CreateEdit(0, ObjName(TR_EDT_MAXDIST), x+60, y+row*(h+PANEL_SPACING), 50, h,
         IntegerToString(g_maxEntrySLDist), g_colors.clrEditText, g_colors.clrEditBg, g_colors.clrEditBorder);
      CreateLabel(0, ObjName("LblMinD"), x+halfW, y+row*(h+PANEL_SPACING)+3, "MinDist:", g_colors.clrLabelText);
      CreateEdit(0, ObjName(TR_EDT_MINDIST), x+halfW+55, y+row*(h+PANEL_SPACING), 50, h,
         IntegerToString(g_minEntrySLDist), g_colors.clrEditText, g_colors.clrEditBg, g_colors.clrEditBorder);
      row++;

      CreateLabel(0, ObjName("LblMaxRP"), x, y+row*(h+PANEL_SPACING)+3, "Max Risk%:", g_colors.clrLabelText);
      CreateEdit(0, ObjName(TR_EDT_MAXRISK), x+80, y+row*(h+PANEL_SPACING), 50, h,
         FormatDouble(g_maxRiskPct, 1), g_colors.clrEditText, g_colors.clrEditBg, g_colors.clrEditBorder);
      row++;
   }

   //--- Max parameters (if enabled)
   if(InpShowMaxParams)
   {
      CreateRectLabel(0, ObjName("SepTrd2"), x, y+row*(h+PANEL_SPACING), w, 1, g_colors.clrSeparator, g_colors.clrSeparator);
      row++;

      CreateLabel(0, ObjName("LblMaxTr"), x, y+row*(h+PANEL_SPACING)+3, "Max Trades:", g_colors.clrLabelText);
      CreateLabel(0, ObjName("LblMTT"), x+90, y+row*(h+PANEL_SPACING)+3, "Tot:", g_colors.clrLabelText);
      CreateEdit(0, ObjName(TR_EDT_MAXTOT), x+115, y+row*(h+PANEL_SPACING), 40, h,
         IntegerToString(g_maxTradesTotal), g_colors.clrEditText, g_colors.clrEditBg, g_colors.clrEditBorder);
      CreateLabel(0, ObjName("LblMTS"), x+160, y+row*(h+PANEL_SPACING)+3, "Sym:", g_colors.clrLabelText);
      CreateEdit(0, ObjName(TR_EDT_MAXSYM), x+190, y+row*(h+PANEL_SPACING), 40, h,
         IntegerToString(g_maxTradesSymbol), g_colors.clrEditText, g_colors.clrEditBg, g_colors.clrEditBorder);
      row++;

      CreateLabel(0, ObjName("LblMaxVl"), x, y+row*(h+PANEL_SPACING)+3, "Max Volume:", g_colors.clrLabelText);
      CreateLabel(0, ObjName("LblMVT"), x+90, y+row*(h+PANEL_SPACING)+3, "Tot:", g_colors.clrLabelText);
      CreateEdit(0, ObjName(TR_EDT_MAXVTOT), x+115, y+row*(h+PANEL_SPACING), 40, h,
         FormatDouble(g_maxVolTotal, 1), g_colors.clrEditText, g_colors.clrEditBg, g_colors.clrEditBorder);
      CreateLabel(0, ObjName("LblMVS"), x+160, y+row*(h+PANEL_SPACING)+3, "Sym:", g_colors.clrLabelText);
      CreateEdit(0, ObjName(TR_EDT_MAXVSYM), x+190, y+row*(h+PANEL_SPACING), 40, h,
         FormatDouble(g_maxVolSymbol, 1), g_colors.clrEditText, g_colors.clrEditBg, g_colors.clrEditBorder);
      row++;

      CreateLabel(0, ObjName("LblMaxRk"), x, y+row*(h+PANEL_SPACING)+3, "Max Risk:", g_colors.clrLabelText);
      CreateLabel(0, ObjName("LblMRT"), x+90, y+row*(h+PANEL_SPACING)+3, "Tot:", g_colors.clrLabelText);
      CreateEdit(0, ObjName(TR_EDT_MAXRTOT), x+115, y+row*(h+PANEL_SPACING), 40, h,
         FormatDouble(g_maxTotalRisk, 1), g_colors.clrEditText, g_colors.clrEditBg, g_colors.clrEditBorder);
      CreateLabel(0, ObjName("LblMRS"), x+160, y+row*(h+PANEL_SPACING)+3, "Sym:", g_colors.clrLabelText);
      CreateEdit(0, ObjName(TR_EDT_MAXRSYM), x+190, y+row*(h+PANEL_SPACING), 40, h,
         FormatDouble(g_maxTotalRiskSym, 1), g_colors.clrEditText, g_colors.clrEditBg, g_colors.clrEditBorder);
      row++;
   }

   //--- Checkboxes (if enabled)
   if(InpShowCheckboxes)
   {
      CreateRectLabel(0, ObjName("SepTrd3"), x, y+row*(h+PANEL_SPACING), w, 1, g_colors.clrSeparator, g_colors.clrSeparator);
      row++;

      CreateButton(0, ObjName(TR_CHK_SUBOPV), x, y+row*(h+PANEL_SPACING), 18, h, g_subtractOPV?"☑":"☐", g_colors.clrLabelText, g_colors.clrBackground);
      CreateLabel(0, ObjName("LblSubOPV"), x+22, y+row*(h+PANEL_SPACING)+3, "Subtract OPV", g_colors.clrLabelText);
      CreateButton(0, ObjName(TR_CHK_SUBPOV), x+halfW, y+row*(h+PANEL_SPACING), 18, h, g_subtractPOV?"☑":"☐", g_colors.clrLabelText, g_colors.clrBackground);
      CreateLabel(0, ObjName("LblSubPOV"), x+halfW+22, y+row*(h+PANEL_SPACING)+3, "Subtract POV", g_colors.clrLabelText);
      row++;

      CreateButton(0, ObjName(TR_CHK_NOSL), x, y+row*(h+PANEL_SPACING), 18, h, g_noStopLoss?"☑":"☐", g_colors.clrLabelText, g_colors.clrBackground);
      CreateLabel(0, ObjName("LblNoSL"), x+22, y+row*(h+PANEL_SPACING)+3, "No SL", g_colors.clrLabelText);
      CreateButton(0, ObjName(TR_CHK_NOTP), x+halfW, y+row*(h+PANEL_SPACING), 18, h, g_noTakeProfit?"☑":"☐", g_colors.clrLabelText, g_colors.clrBackground);
      CreateLabel(0, ObjName("LblNoTP"), x+halfW+22, y+row*(h+PANEL_SPACING)+3, "No TP", g_colors.clrLabelText);
      row++;

      CreateButton(0, ObjName(TR_CHK_HIDDEN), x, y+row*(h+PANEL_SPACING), 18, h, g_disableTradingHidden?"☑":"☐", g_colors.clrLabelText, g_colors.clrBackground);
      CreateLabel(0, ObjName("LblDisHid"), x+22, y+row*(h+PANEL_SPACING)+3, "Disable if hidden", g_colors.clrLabelText);
      CreateButton(0, ObjName(TR_CHK_CONFIRM), x+halfW, y+row*(h+PANEL_SPACING), 18, h, g_askConfirmation?"☑":"☐", g_colors.clrLabelText, g_colors.clrBackground);
      CreateLabel(0, ObjName("LblConfirm"), x+halfW+22, y+row*(h+PANEL_SPACING)+3, "Confirm", g_colors.clrLabelText);
      row++;
   }

   //--- Expiry
   if(g_orderMode != ORDER_MODE_INSTANT)
   {
      CreateLabel(0, ObjName("LblExpiry"), x, y+row*(h+PANEL_SPACING)+3, "Expiry (min):", g_colors.clrLabelText);
      CreateEdit(0, ObjName(TR_EDT_EXPIRY), x+100, y+row*(h+PANEL_SPACING), 50, h,
         IntegerToString(g_expiryMinutes), g_colors.clrEditText, g_colors.clrEditBg, g_colors.clrEditBorder);
      row++;
   }

   //--- Multi-TP section
   if(g_tpCount > 1)
   {
      CreateRectLabel(0, ObjName("SepTrd4"), x, y+row*(h+PANEL_SPACING), w, 1, g_colors.clrSeparator, g_colors.clrSeparator);
      row++;

      CreateButton(0, ObjName(TR_BTN_FILL_IN), x, y+row*(h+PANEL_SPACING), 65, h,
         "Fill In", g_colors.clrButtonText, g_colors.clrButtonBg);
      CreateButton(0, ObjName(TR_BTN_FILL_OUT), x+70, y+row*(h+PANEL_SPACING), 65, h,
         "Fill Out", g_colors.clrButtonText, g_colors.clrButtonBg);
      string shareText = (g_shareMode==SHARE_EQUAL)?"Equal":(g_shareMode==SHARE_DESCENDING)?"Desc":"Asc";
      CreateButton(0, ObjName(TR_BTN_SHARE), x+140, y+row*(h+PANEL_SPACING), 55, h,
         shareText, g_colors.clrButtonText, g_colors.clrButtonBg);
      row++;

      //--- TP table header
      CreateLabel(0, ObjName("LblTPH1"), x, y+row*(h+PANEL_SPACING)+3, "TP#", g_colors.clrLabelText);
      CreateLabel(0, ObjName("LblTPH2"), x+35, y+row*(h+PANEL_SPACING)+3, "Price", g_colors.clrLabelText);
      CreateLabel(0, ObjName("LblTPH3"), x+140, y+row*(h+PANEL_SPACING)+3, "Share%", g_colors.clrLabelText);
      CreateLabel(0, ObjName("LblTPH4"), x+200, y+row*(h+PANEL_SPACING)+3, "Lots", g_colors.clrLabelText);
      row++;

      for(int i = 0; i < g_tpCount; i++)
      {
         string idx = IntegerToString(i+1);
         CreateLabel(0, ObjName("LblTPR"+idx), x, y+row*(h+PANEL_SPACING)+3, idx, g_colors.clrLabelText);
         CreateEdit(0, ObjName("EdtTPR"+idx), x+20, y+row*(h+PANEL_SPACING), 110, h,
            FormatDouble(g_tpLevels[i].price, GetSymbolDigits()), g_colors.clrEditText, g_colors.clrEditBg, g_colors.clrEditBorder);
         CreateEdit(0, ObjName("EdtTPS"+idx), x+135, y+row*(h+PANEL_SPACING), 55, h,
            FormatDouble(g_tpLevels[i].sharePct, 1), g_colors.clrEditText, g_colors.clrEditBg, g_colors.clrEditBorder);
         CreateLabel(0, ObjName("ValTPL"+idx), x+195, y+row*(h+PANEL_SPACING)+3,
            FormatDouble(g_tpLevels[i].lots, 2), g_colors.clrResultText);
         row++;
      }
   }

   g_tradingTabHeight = row * (h + PANEL_SPACING) + PANEL_SPACING;
}

//+------------------------------------------------------------------+
bool HandleTradingTabClick(string clickedObj)
{
   if(IsObjectClicked(clickedObj, TR_BTN_TRADE))     { ExecuteTrade(); return true; }
   if(IsObjectClicked(clickedObj, TR_CHK_SUBOPV))    { g_subtractOPV = !g_subtractOPV; return true; }
   if(IsObjectClicked(clickedObj, TR_CHK_SUBPOV))    { g_subtractPOV = !g_subtractPOV; return true; }
   if(IsObjectClicked(clickedObj, TR_CHK_NOSL))      { g_noStopLoss = !g_noStopLoss; return true; }
   if(IsObjectClicked(clickedObj, TR_CHK_NOTP))      { g_noTakeProfit = !g_noTakeProfit; return true; }
   if(IsObjectClicked(clickedObj, TR_CHK_HIDDEN))    { g_disableTradingHidden = !g_disableTradingHidden; return true; }
   if(IsObjectClicked(clickedObj, TR_CHK_CONFIRM))   { g_askConfirmation = !g_askConfirmation; return true; }
   if(IsObjectClicked(clickedObj, TR_CHK_SUFFIX))    { g_autoSuffix = !g_autoSuffix; return true; }

   if(IsObjectClicked(clickedObj, TR_BTN_SHARE))
   {
      g_shareMode = (ENUM_SHARE_MODE)(((int)g_shareMode + 1) % 3);
      ApplyShareDistribution();
      return true;
   }
   if(IsObjectClicked(clickedObj, TR_BTN_FILL_IN))   { FillTPsInward(); return true; }
   if(IsObjectClicked(clickedObj, TR_BTN_FILL_OUT))  { FillTPsOutward(); return true; }

   return false;
}

//+------------------------------------------------------------------+
bool HandleTradingTabEdit(string editObj)
{
   if(IsObjectClicked(editObj, TR_EDT_TRAIL))   { g_trailingStop = (int)StringToInteger(ObjectGetString(0, ObjName(TR_EDT_TRAIL), OBJPROP_TEXT)); return true; }
   if(IsObjectClicked(editObj, TR_EDT_BE))      { g_breakEven = (int)StringToInteger(ObjectGetString(0, ObjName(TR_EDT_BE), OBJPROP_TEXT)); return true; }
   if(IsObjectClicked(editObj, TR_EDT_MAGIC))   { g_magicNumber = StringToInteger(ObjectGetString(0, ObjName(TR_EDT_MAGIC), OBJPROP_TEXT)); return true; }
   if(IsObjectClicked(editObj, TR_EDT_COMMENT)) { g_commentary = ObjectGetString(0, ObjName(TR_EDT_COMMENT), OBJPROP_TEXT); return true; }
   if(IsObjectClicked(editObj, TR_EDT_SLIP))    { g_maxSlippage = (int)StringToInteger(ObjectGetString(0, ObjName(TR_EDT_SLIP), OBJPROP_TEXT)); return true; }
   if(IsObjectClicked(editObj, TR_EDT_SPREAD))  { g_maxSpread = (int)StringToInteger(ObjectGetString(0, ObjName(TR_EDT_SPREAD), OBJPROP_TEXT)); return true; }
   if(IsObjectClicked(editObj, TR_EDT_MAXDIST)) { g_maxEntrySLDist = (int)StringToInteger(ObjectGetString(0, ObjName(TR_EDT_MAXDIST), OBJPROP_TEXT)); return true; }
   if(IsObjectClicked(editObj, TR_EDT_MINDIST)) { g_minEntrySLDist = (int)StringToInteger(ObjectGetString(0, ObjName(TR_EDT_MINDIST), OBJPROP_TEXT)); return true; }
   if(IsObjectClicked(editObj, TR_EDT_MAXRISK)) { g_maxRiskPct = StringToDouble(ObjectGetString(0, ObjName(TR_EDT_MAXRISK), OBJPROP_TEXT)); return true; }
   if(IsObjectClicked(editObj, TR_EDT_MAXTOT))  { g_maxTradesTotal = (int)StringToInteger(ObjectGetString(0, ObjName(TR_EDT_MAXTOT), OBJPROP_TEXT)); return true; }
   if(IsObjectClicked(editObj, TR_EDT_MAXSYM))  { g_maxTradesSymbol = (int)StringToInteger(ObjectGetString(0, ObjName(TR_EDT_MAXSYM), OBJPROP_TEXT)); return true; }
   if(IsObjectClicked(editObj, TR_EDT_MAXVTOT)) { g_maxVolTotal = StringToDouble(ObjectGetString(0, ObjName(TR_EDT_MAXVTOT), OBJPROP_TEXT)); return true; }
   if(IsObjectClicked(editObj, TR_EDT_MAXVSYM)) { g_maxVolSymbol = StringToDouble(ObjectGetString(0, ObjName(TR_EDT_MAXVSYM), OBJPROP_TEXT)); return true; }
   if(IsObjectClicked(editObj, TR_EDT_MAXRTOT)) { g_maxTotalRisk = StringToDouble(ObjectGetString(0, ObjName(TR_EDT_MAXRTOT), OBJPROP_TEXT)); return true; }
   if(IsObjectClicked(editObj, TR_EDT_MAXRSYM)) { g_maxTotalRiskSym = StringToDouble(ObjectGetString(0, ObjName(TR_EDT_MAXRSYM), OBJPROP_TEXT)); return true; }
   if(IsObjectClicked(editObj, TR_EDT_EXPIRY))  { g_expiryMinutes = (int)StringToInteger(ObjectGetString(0, ObjName(TR_EDT_EXPIRY), OBJPROP_TEXT)); return true; }

   //--- Multi-TP edits
   for(int i = 0; i < g_tpCount; i++)
   {
      string idx = IntegerToString(i+1);
      if(IsObjectClicked(editObj, "EdtTPR"+idx))
      {
         g_tpLevels[i].price = NormalizePrice(StringToDouble(ObjectGetString(0, ObjName("EdtTPR"+idx), OBJPROP_TEXT)));
         if(i == 0) g_takeProfitPrice = g_tpLevels[0].price;
         return true;
      }
      if(IsObjectClicked(editObj, "EdtTPS"+idx))
      {
         g_tpLevels[i].sharePct = StringToDouble(ObjectGetString(0, ObjName("EdtTPS"+idx), OBJPROP_TEXT));
         return true;
      }
   }
   return false;
}

//+------------------------------------------------------------------+
void ApplyShareDistribution()
{
   if(g_tpCount <= 1) return;
   for(int i = 0; i < g_tpCount; i++)
   {
      switch(g_shareMode)
      {
         case SHARE_EQUAL:
            g_tpLevels[i].sharePct = 100.0 / g_tpCount;
            break;
         case SHARE_DESCENDING:
         {
            double total = g_tpCount * (g_tpCount + 1) / 2.0;
            g_tpLevels[i].sharePct = (g_tpCount - i) / total * 100.0;
            break;
         }
         case SHARE_ASCENDING:
         {
            double total = g_tpCount * (g_tpCount + 1) / 2.0;
            g_tpLevels[i].sharePct = (i + 1) / total * 100.0;
            break;
         }
      }
   }
}

//+------------------------------------------------------------------+
void FillTPsInward()
{
   if(g_tpCount <= 1 || g_takeProfitPrice == 0) return;
   double entry = GetEntryPrice();
   double tpDist = MathAbs(g_takeProfitPrice - entry);
   for(int i = 0; i < g_tpCount; i++)
   {
      double d = tpDist * (i + 1) / g_tpCount;
      g_tpLevels[i].price = (g_tradeDir == TRADE_DIR_LONG)
         ? NormalizePrice(entry + d) : NormalizePrice(entry - d);
   }
}

//+------------------------------------------------------------------+
void FillTPsOutward()
{
   if(g_tpCount <= 1 || g_takeProfitPrice == 0) return;
   double entry = GetEntryPrice();
   double tpDist = MathAbs(g_takeProfitPrice - entry);
   for(int i = 0; i < g_tpCount; i++)
   {
      double d = tpDist * (1.0 + (double)i);
      g_tpLevels[i].price = (g_tradeDir == TRADE_DIR_LONG)
         ? NormalizePrice(entry + d) : NormalizePrice(entry - d);
   }
}

#endif // PANEL_TRADING_MQH
